/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class InstancesTest
extends TestCase {
    protected Instances m_Instances;

    public InstancesTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = ConverterUtils.DataSource.read(ClassLoader.getSystemResourceAsStream("weka/core/data/InstancesTest.arff"));
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_Instances = null;
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(InstancesTest.class);
    }

    public void testCreationUnique() {
        String relName = "testCreationUnique";
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("att-numeric_1"));
        atts.add(new Attribute("att-numeric_2"));
        atts.add(new Attribute("att-data_1", "yyyy-MM-dd HH:mm"));
        atts.add(new Attribute("att-nominal_1", new ArrayList<String>(Arrays.asList("1", "2", "3"))));
        atts.add(new Attribute("att-nominal_2", new ArrayList<String>(Arrays.asList("yes", "no"))));
        atts.add(new Attribute("att-string_1", null));
        Instances data = new Instances(relName, atts, 0);
        InstancesTest.assertEquals("relation name differs", relName, data.relationName());
        InstancesTest.assertEquals("# of attributes differ", atts.size(), data.numAttributes());
    }

    public void testCreationAmbiguous() {
        Instances data;
        String relName = "testCreationAmbiguous";
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("att-numeric_1"));
        atts.add(new Attribute("att-numeric_1"));
        atts.add(new Attribute("att-data_1", "yyyy-MM-dd HH:mm"));
        atts.add(new Attribute("att-nominal_1", new ArrayList<String>(Arrays.asList("1", "2", "3"))));
        atts.add(new Attribute("att-nominal_1", new ArrayList<String>(Arrays.asList("yes", "no"))));
        atts.add(new Attribute("att-string_1", null));
        try {
            data = new Instances(relName, atts, 0);
        }
        catch (IllegalArgumentException e) {
            data = null;
        }
        InstancesTest.assertNull("dataset created with ambiguous attribute names", data);
    }

    public void testHeaderCopy() {
        Instances data = new Instances(this.m_Instances, 0);
        InstancesTest.assertEquals("# of attributes differ", this.m_Instances.numAttributes(), data.numAttributes());
        InstancesTest.assertEquals("class index differs", this.m_Instances.classIndex(), data.classIndex());
        InstancesTest.assertEquals("Unexpected instances", 0, data.numInstances());
        this.m_Instances.setClassIndex(this.m_Instances.numAttributes() - 1);
        data = new Instances(this.m_Instances, 0);
        InstancesTest.assertEquals("class index differs", this.m_Instances.classIndex(), data.classIndex());
    }

    public void testFullCopy() {
        Instances data = new Instances(this.m_Instances);
        InstancesTest.assertEquals("# of attributes differ", this.m_Instances.numAttributes(), data.numAttributes());
        InstancesTest.assertEquals("class index differs", this.m_Instances.classIndex(), data.classIndex());
        InstancesTest.assertEquals("# of instances differ", this.m_Instances.numInstances(), data.numInstances());
        this.m_Instances.setClassIndex(this.m_Instances.numAttributes() - 1);
        data = new Instances(this.m_Instances);
        InstancesTest.assertEquals("class index differs", this.m_Instances.classIndex(), data.classIndex());
    }

    public void testPartialCopy() {
        Instances data = new Instances(this.m_Instances, 0, this.m_Instances.numInstances());
        InstancesTest.assertEquals("# of instances differ", this.m_Instances.numInstances(), data.numInstances());
        data = new Instances(this.m_Instances, 5, 10);
        InstancesTest.assertEquals("# of instances differ", 10, data.numInstances());
    }

    public static void main(String[] args) {
        TestRunner.run(InstancesTest.suite());
    }
}

